document.addEventListener("DOMContentLoaded", function () {

    // daterangepicker
    var enableDatepicker = $().daterangepicker();
    if (typeof enableDatepicker != "undefined" && enableDatepicker != null) {
        $(function () {
            $('input[name="singleDate"]').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                minYear: 1901,
                maxYear: parseInt(moment().format('YYYY'), 10)
            });
        });

        //range date
        $(function () {
            $('input[name="daterange"]').daterangepicker({
                locale: {
                    format: 'DD/MM/YYYY'
                },
                ranges: {
                    'oggi': [moment(), moment()],
                    'ieri': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Ultimi 7 giorni': [moment().subtract(6, 'days'), moment()],
                    'Ultimi 30 giorni': [moment().subtract(29, 'days'), moment()],
                    'Mese corrente': [moment().startOf('month'), moment().endOf('month')],
                    'Mese precedente': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
                showISOWeekNumbers: true,
                showWeekNumbers: true,
                showDropdowns: true,
                startDate: moment(),
                endDate: moment().add(2, 'day')
            });
            $('input[name="dates"]').val('');
            $('input[name="dates"]').attr("placeholder", "Seleziona periodo");
        })
    }

    //map
    /*
    if (typeof L != "undefined" && L != null) {
        var map1 = L.map('map-1').setView([41.117143, 16.871871], 10);
        L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
            maxZoom: 19,
            attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
        }).addTo(map1);
    }


    if (typeof L != "undefined" && L != null) {
        var map2 = L.map('map-2').setView([41.117143, 16.871871], 10);
        L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
            maxZoom: 19,
            attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
        }).addTo(map2);
    }
    */


    //switch
    let wkSwitchToggle = document.querySelectorAll(".wk-switch .switch");
    wkSwitchToggle.forEach(element => {
        element.addEventListener('keypress', function (e) {
            element.parentElement.classList.toggle("active");
        });
        element.addEventListener('click', function (e) {
            element.parentElement.classList.toggle("active");
        });
    });

    //filter
    let wkFilterToggle = document.querySelectorAll(".filter-btn");
    wkFilterToggle.forEach(element => {
        element.addEventListener('click', function (e) {
            element.classList.toggle("active");
        });
    });


    // SLICK
    $('.wk-slider-1').slick({
        dots: false,
        infinite: true,
        speed: 300,
        slidesToShow: 3,
        slidesToScroll: 3,
        responsive: [{
            breakpoint: 1024,
            settings: {
                slidesToShow: 3,
                slidesToScroll: 3,
                infinite: true,
                dots: false
            }
        },
        {
            breakpoint: 600,
            settings: {
                slidesToShow: 2,
                slidesToScroll: 2
            }
        },
        {
            breakpoint: 480,
            settings: {
                slidesToShow: 1,
                slidesToScroll: 1
            }
        }
            // You can unslick at a given breakpoint now by adding:
            // settings: "unslick"
            // instead of a settings object
        ]
    });


    // SLICK MEDIA
    $('.wk-slider-media').slick({
        dots: false,
        infinite: true,
        speed: 300,
        slidesToShow: 3,
        slidesToScroll: 3,
        responsive: [{
            breakpoint: 1024,
            settings: {
                slidesToShow: 3,
                slidesToScroll: 3,
                infinite: true,
                dots: false
            }
        },
        {
            breakpoint: 600,
            settings: {
                slidesToShow: 2,
                slidesToScroll: 2
            }
        },
        {
            breakpoint: 480,
            settings: {
                slidesToShow: 1,
                slidesToScroll: 1
            }
        }
        ]
    });


    var sliderBtnBottom = document.querySelectorAll(".slick-media-card");
    if (typeof sliderBtnBottom != "undefined" && sliderBtnBottom != null) {
        sliderBtnBottom.forEach(element => {
            var wrapperSlickBtn = document.createElement("div");
            var wrapperCounter = document.createElement("div");
            wrapperSlickBtn.className = "custom-wrap-btn d-flex justify-content-between align-items-center";
            wrapperCounter.className = "custom-wrap-counter";
            var btnLeft = element.querySelector(".slick-prev");
            var btnRight = element.querySelector(".slick-next");

            wrapperCounter.innerHTML = "1-3 di 12"

            if (btnLeft)
                btnLeft.classList.add("position-relative");
            if (btnRight)
                btnRight.classList.add("position-relative");

            element.append(wrapperSlickBtn);
            wrapperSlickBtn.append(btnLeft);
            wrapperSlickBtn.append(wrapperCounter);
            wrapperSlickBtn.append(btnRight);
        });
    }


    // Datatable
    /* Formatting function for row details - modify as you need */
    function format(d) {
        // `d` is the original data object for the row
        return (
            '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">' +
            '<tr>' +
            '<td><strong>Campo 5</strong></td>' +
            '<td>' +
            d.ExtraInfo +
            '</td>' +
            '</tr>' +
            '</table>'
        );
    }

    // Add event listener for opening and closing details
    $('#responsive-col-example').on('click', 'tbody td.dt-control', function () {
        var tr = $(this).closest('tr');
        var row = table.row(tr);

        if (row.child.isShown()) {
            // This row is already open - close it
            row.child.hide();
        } else {
            // Open this row
            row.child(format(row.data())).show();
        }
    });

    $('#responsive-col-example').on('requestChild.dt', function (e, row) {
        row.child(format(row.data())).show();
    });

    var table = $('#responsive-col-example').DataTable({
        ajax: '../ajax/data/objects.txt',
        rowId: 'id',
        stateSave: true,
        "lengthMenu": [
            [10, 25, 50],
            [10, 25, 50]
        ],
        //"dom": '<"top><"bottom"lip>',
        "dom": '<"top><"bottom"><"wk-paginator"lip>',
        "language": {
            "lengthMenu": "_MENU_ <span>elementi</span>",
            "info": "Mostra _PAGE_ - _PAGES_ su _TOTAL_ risultati",
            "paginate": {
                "first": "Prima",
                "last": "Ultima",
                "next": "",
                "previous": "",
            }
        },

        columns: [{
            className: 'dt-control',
            orderable: false,
            data: 'Campo 0',
            defaultContent: '',
        },
        {
            data: 'Campo 1'
        },
        {
            data: 'Campo 2'
        },
        {
            data: 'Campo 3'
        },
        ],
        order: [
            [1, 'asc']
        ],
    });

    $('#type-1-example').DataTable({
        "lengthMenu": [
            [10, 25, 50],
            [10, 25, 50]
        ],
        //"dom": '<"top><"bottom"lip>',
        "dom": '<"top><"bottom"><"wk-paginator"lip>',
        "language": {
            "lengthMenu": "_MENU_ <span>elementi</span>",
            "info": "Mostra _PAGE_ - _PAGES_ su _TOTAL_ risultati",
            "paginate": {
                "first": "Prima",
                "last": "Ultima",
                "next": "",
                "previous": "",
            }
        }
    });

    $('#type-2-example').DataTable({
        "lengthMenu": [
            [10, 25, 50],
            [10, 25, 50]
        ],
        //"dom": '<"top><"bottom"lip>',
        "dom": '<"top><"bottom"><"wk-paginator"lip>',
        "language": {
            "lengthMenu": "_MENU_ <span>elementi</span>",
            "info": "Mostra _PAGE_ - _PAGES_ su _TOTAL_ risultati",
            "paginate": {
                "first": "Prima",
                "last": "Ultima",
                "next": "",
                "previous": "",
            }
        }
    });

});